/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.git.core.model.ChangedFile;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.IGitRepositoryManager;
import com.aptana.git.ui.DiffFormatter;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.actions.Messages;
import com.aptana.git.ui.internal.actions.AbstractGitHandler;
import com.aptana.ui.util.SafeMessageDialogRunnable;
import com.aptana.ui.util.UIUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffHandler
extends AbstractGitHandler {
    @Override
    protected boolean calculateEnabled() {
        return !this.getSelectedChangedFiles().isEmpty();
    }

    private List<ChangedFile> getSelectedChangedFiles() {
        ArrayList<ChangedFile> changedFiles = new ArrayList<ChangedFile>();
        IGitRepositoryManager manager = DiffHandler.getGitRepositoryManager();
        if (manager == null) {
            return changedFiles;
        }
        GitRepository repo = null;
        for (IResource resource : this.getSelectedResources()) {
            if (resource == null) continue;
            if (repo == null) {
                repo = manager.getAttached(resource.getProject());
            }
            changedFiles.addAll(this.getChangedFilesForResource(repo, resource));
        }
        return changedFiles;
    }

    private List<ChangedFile> getChangedFilesForResource(GitRepository repo, IResource resource) {
        ArrayList<ChangedFile> files = new ArrayList<ChangedFile>();
        if (repo == null) {
            return files;
        }
        if (resource instanceof IContainer) {
            files.addAll(repo.getChangedFilesForContainer((IContainer)resource));
        } else {
            ChangedFile changedFile = repo.getChangedFileForResource(resource);
            if (changedFile != null) {
                files.add(changedFile);
            }
        }
        return files;
    }

    @Override
    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        HashMap<IPath, String> diffs = new HashMap<IPath, String>();
        List<ChangedFile> changedFiles = this.getSelectedChangedFiles();
        if (changedFiles == null || changedFiles.isEmpty()) {
            return null;
        }
        GitRepository repo = this.getSelectedRepository();
        if (repo == null) {
            return null;
        }
        for (ChangedFile file : changedFiles) {
            if (file == null || diffs.containsKey(file.getRelativePath())) continue;
            String diff = repo.index().diffForFile(file, file.hasStagedChanges(), 3);
            diffs.put(file.getRelativePath(), diff);
        }
        if (diffs.isEmpty()) {
            return null;
        }
        String diff = "";
        try {
            diff = DiffFormatter.toHTML(diffs);
        }
        catch (Throwable t) {
            IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (String)"Failed to turn diff into HTML", (Throwable)t, (String)"com.aptana.git.core/debug");
        }
        final String finalDiff = diff;
        UIUtils.showMessageDialogFromBgThread((SafeMessageDialogRunnable)new SafeMessageDialogRunnable(){

            public int openMessageDialog() {
                MessageDialog dialog = new MessageDialog(DiffHandler.this.getShell(), Messages.GitProjectView_GitDiffDialogTitle, null, "", 0, new String[]{IDialogConstants.OK_LABEL}, 0){

                    protected Control createCustomArea(Composite parent) {
                        Browser diffArea = new Browser(parent, 2048);
                        GridData data = new GridData(4, 4, true, true);
                        data.heightHint = 300;
                        diffArea.setLayoutData((Object)data);
                        diffArea.setText(finalDiff);
                        return diffArea;
                    }

                    protected boolean isResizable() {
                        return true;
                    }
                };
                return dialog.open();
            }
        });
        return null;
    }
}

